/**
 * CommandTypes
 * @description Flags that modify a command's execution
 * @enum {number}
 */
export declare enum CommandType {
    V3_SWAP_EXACT_IN = 0,
    V3_SWAP_EXACT_OUT = 1,
    PERMIT2_TRANSFER_FROM = 2,
    PERMIT2_PERMIT_BATCH = 3,
    SWEEP = 4,
    TRANSFER = 5,
    PAY_PORTION = 6,
    V2_SWAP_EXACT_IN = 8,
    V2_SWAP_EXACT_OUT = 9,
    PERMIT2_PERMIT = 10,
    WRAP_ETH = 11,
    UNWRAP_WETH = 12,
    PERMIT2_TRANSFER_FROM_BATCH = 13,
    BALANCE_CHECK_ERC20 = 14,
    V4_SWAP = 16,
    V3_POSITION_MANAGER_PERMIT = 17,
    V3_POSITION_MANAGER_CALL = 18,
    V4_INITIALIZE_POOL = 19,
    V4_POSITION_MANAGER_CALL = 20,
    EXECUTE_SUB_PLAN = 33
}
export declare enum Subparser {
    V3PathExactIn = 0,
    V3PathExactOut = 1
}
export declare enum Parser {
    Abi = 0,
    V4Actions = 1,
    V3Actions = 2
}
export declare type ParamType = {
    readonly name: string;
    readonly type: string;
    readonly subparser?: Subparser;
};
export declare type CommandDefinition = {
    parser: Parser.Abi;
    params: ParamType[];
} | {
    parser: Parser.V4Actions;
} | {
    parser: Parser.V3Actions;
};
export declare const COMMAND_DEFINITION: {
    [key in CommandType]: CommandDefinition;
};
export declare class RoutePlanner {
    commands: string;
    inputs: string[];
    constructor();
    addSubPlan(subplan: RoutePlanner): RoutePlanner;
    addCommand(type: CommandType, parameters: any[], allowRevert?: boolean): RoutePlanner;
}
export declare type RouterCommand = {
    type: CommandType;
    encodedInput: string;
};
export declare function createCommand(type: CommandType, parameters: any[]): RouterCommand;
